<?php
/**
 * Uninstall ArtistPro Security
 * Fired when the plugin is uninstalled
 *
 * @package ArtistPro_Security
 * @since 1.1.0
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Check if user wants to keep data
$keep_data = get_option('artistpro_security_keep_data_on_uninstall', false);

if (!$keep_data) {
    // Drop all tables
    $tables = array(
        $wpdb->prefix . 'artistpro_security_logs',
        $wpdb->prefix . 'artistpro_security_lockouts',
        $wpdb->prefix . 'artistpro_security_ip_lists',
        $wpdb->prefix . 'artistpro_security_blocked_countries',
        $wpdb->prefix . 'artistpro_security_stats',
    );

    foreach ($tables as $table) {
        $wpdb->query("DROP TABLE IF EXISTS {$table}");
    }

    // Delete all options
    $wpdb->query(
        "DELETE FROM {$wpdb->options} 
         WHERE option_name LIKE 'artistpro_security_%'"
    );

    // Delete all user meta (2FA settings, etc.)
    $wpdb->query(
        "DELETE FROM {$wpdb->usermeta} 
         WHERE meta_key LIKE 'artistpro_2fa_%'"
    );

    // Clear scheduled cron jobs
    wp_clear_scheduled_hook('artistpro_security_sync_blocklists');
    wp_clear_scheduled_hook('artistpro_security_cleanup');
    wp_clear_scheduled_hook('artistpro_security_initial_sync');
} else {
    // User wants to keep data - just deactivate
    update_option('artistpro_security_uninstalled_but_kept_data', current_time('mysql'));
}

// Log uninstall
error_log('ArtistPro Security: Plugin uninstalled. Data kept: ' . ($keep_data ? 'Yes' : 'No'));
